package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.Vlistestprev;
import com.ejie.ab04b.util.Utilities;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * VlistestprevDaoImpl generated by UDA, 19-sep-2017 13:57:15.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class VlistestprevDaoImpl implements VlistestprevDao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Vlistestprev> rwMap = new RowMapper<Vlistestprev>() {
		public Vlistestprev mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Vlistestprev(resultSet.getString("ANIO"),
					resultSet.getString("TERRITORIO"),
					resultSet.getString("MES"),
					resultSet.getString("TIPODOCUMENTO"),
					resultSet.getString("MODDALIES"),
					resultSet.getString("MODALIEU"),
					resultSet.getString("AUDITORIA"));
		}
	};

	private RowMapper<Vlistestprev> rwMapPK = new RowMapper<Vlistestprev>() {
		public Vlistestprev mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Vlistestprev(resultSet.getString("ANIO"),
					resultSet.getString("TERRITORIO"),
					resultSet.getString("MES"),
					resultSet.getString("TIPODOCUMENTO"),
					resultSet.getString("MODDALIES"),
					resultSet.getString("MODALIEU"),
					resultSet.getString("AUDITORIA"));
		}
	};

	private RowMapper<Vlistestprev> rwMapListEstSinAgru = new RowMapper<Vlistestprev>() {
		public Vlistestprev mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Vlistestprev comunicacionPrl = new Vlistestprev();

			long total = resultSet.getLong("TOTAL") > 0 ? resultSet
					.getLong("TOTAL") : (long) 0;
			comunicacionPrl.setTotal(total);

			String anio = resultSet.getString("ANIO") != null ? resultSet
					.getString("ANIO") : "";
			comunicacionPrl.setAnio(anio);

			String territorio = resultSet.getString("TERRITORIO") != null ? resultSet
					.getString("TERRITORIO") : "";
			comunicacionPrl.setTerritorioDesc(Utilities.getInstance()
					.strTerritorio(territorio));

			String mes = resultSet.getString("MES") != null ? resultSet
					.getString("MES") : "";
			if (!"".equals(mes)) {
				comunicacionPrl.setMes(Utilities.getInstance().strMonth(
						Integer.parseInt(mes)));
			} else {
				comunicacionPrl.setMes("");
			}

			String tipodoc = resultSet.getString("TIPODOCUMENTO") != null ? resultSet
					.getString("TIPODOCUMENTO") : "";
			comunicacionPrl.setTipodocumento(tipodoc);

			comunicacionPrl.setModalies("");
			comunicacionPrl.setModalieu("");
			comunicacionPrl.setAuditoria("");

			return comunicacionPrl;
		}
	};

	private RowMapper<Vlistestprev> rwMapListEstMOP = new RowMapper<Vlistestprev>() {
		public Vlistestprev mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Vlistestprev comunicacionPrl = new Vlistestprev();

			long total = resultSet.getLong("TOTAL") > 0 ? resultSet
					.getLong("TOTAL") : (long) 0;
			comunicacionPrl.setTotal(total);

			String anio = resultSet.getString("ANIO") != null ? resultSet
					.getString("ANIO") : "";
			comunicacionPrl.setAnio(anio);

			String territorio = resultSet.getString("TERRITORIO") != null ? resultSet
					.getString("TERRITORIO") : "";
			comunicacionPrl.setTerritorioDesc(Utilities.getInstance()
					.strTerritorio(territorio));

			String mes = resultSet.getString("MES") != null ? resultSet
					.getString("MES") : "";
			if (!"".equals(mes)) {
				comunicacionPrl.setMes(Utilities.getInstance().strMonth(
						Integer.parseInt(mes)));
			} else {
				comunicacionPrl.setMes("");
			}

			String tipodoc = resultSet.getString("TIPODOCUMENTO") != null ? resultSet
					.getString("TIPODOCUMENTO") : "";
			comunicacionPrl.setTipodocumento(tipodoc);

			String mopes = resultSet.getString("MODALIES") != null ? resultSet
					.getString("MODALIES") : "";
			String mopeu = resultSet.getString("MODALIEU") != null ? resultSet
					.getString("MODALIEU") : "";
			comunicacionPrl.setModalies(mopes);
			comunicacionPrl.setModalieu(mopeu);

			comunicacionPrl.setAuditoria("");

			return comunicacionPrl;
		}
	};

	private RowMapper<Vlistestprev> rwMapListEstAudi = new RowMapper<Vlistestprev>() {
		public Vlistestprev mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Vlistestprev comunicacionPrl = new Vlistestprev();

			long total = resultSet.getLong("TOTAL") > 0 ? resultSet
					.getLong("TOTAL") : (long) 0;
			comunicacionPrl.setTotal(total);

			String anio = resultSet.getString("ANIO") != null ? resultSet
					.getString("ANIO") : "";
			comunicacionPrl.setAnio(anio);

			String territorio = resultSet.getString("TERRITORIO") != null ? resultSet
					.getString("TERRITORIO") : "";
			comunicacionPrl.setTerritorioDesc(Utilities.getInstance()
					.strTerritorio(territorio));

			String mes = resultSet.getString("MES") != null ? resultSet
					.getString("MES") : "";
			if (!"".equals(mes)) {
				comunicacionPrl.setMes(Utilities.getInstance().strMonth(
						Integer.parseInt(mes)));
			} else {
				comunicacionPrl.setMes("");
			}

			String tipodoc = resultSet.getString("TIPODOCUMENTO") != null ? resultSet
					.getString("TIPODOCUMENTO") : "";
			comunicacionPrl.setTipodocumento(tipodoc);

			String indaud = resultSet.getString("AUDITORIA") != null ? resultSet
					.getString("AUDITORIA") : "";
			comunicacionPrl.setAuditoria(indaud);

			comunicacionPrl.setModalies("");
			comunicacionPrl.setModalieu("");

			return comunicacionPrl;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 * 
	 * @param dataSource
	 *            the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Vlistestprev table.
	 * 
	 * vlistestprev Vlistestprev Vlistestprev
	 * 
	 * @param vlistestprev
	 *            the vlistestprev
	 * @return the vlistestprev
	 */
	public Vlistestprev add(Vlistestprev vlistestprev) {
		String query = "INSERT INTO VLISTESTPREV (ANIO, TERRITORIO, MES, TIPODOCUMENTO, MODDALIES, MODALIEU, AUDITORIA) VALUES (?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, vlistestprev.getAnio(),
				vlistestprev.getTerritorio(), vlistestprev.getMes(),
				vlistestprev.getTipodocumento(), vlistestprev.getModalies(),
				vlistestprev.getModalieu(), vlistestprev.getAuditoria());
		return vlistestprev;
	}

	/**
	 * Updates a single row in the Vlistestprev table.
	 * 
	 * vlistestprev Vlistestprev Vlistestprev
	 * 
	 * @param vlistestprev
	 *            the vlistestprev
	 * @return the vlistestprev
	 */
	public Vlistestprev update(Vlistestprev vlistestprev) {
		String query = "UPDATE VLISTESTPREV SET  WHERE ANIO=? AND TERRITORIO=? AND MES=? AND TIPODOCUMENTO=? AND MODDALIES=? AND MODALIEU=? AND AUDITORIA=?";
		this.jdbcTemplate.update(query, vlistestprev.getAnio(),
				vlistestprev.getTerritorio(), vlistestprev.getMes(),
				vlistestprev.getTipodocumento(), vlistestprev.getModalies(),
				vlistestprev.getModalieu(), vlistestprev.getAuditoria());
		return vlistestprev;
	}

	/**
	 * Finds a single row in the Vlistestprev table.
	 * 
	 * vlistestprev Vlistestprev Vlistestprev
	 * 
	 * @param vlistestprev
	 *            the vlistestprev
	 * @return the vlistestprev
	 */
	@Transactional(readOnly = true)
	public Vlistestprev find(Vlistestprev vlistestprev) {
		String query = "SELECT t1.ANIO ANIO, t1.TERRITORIO TERRITORIO, t1.MES MES, t1.TIPODOCUMENTO TIPODOCUMENTO, t1.MODDALIES MODDALIES, t1.MODALIEU MODALIEU, t1.AUDITORIA AUDITORIA FROM VLISTESTPREV t1  WHERE t1.ANIO = ?   AND t1.TERRITORIO = ?   AND t1.MES = ?   AND t1.TIPODOCUMENTO = ?   AND t1.MODDALIES = ?   AND t1.MODALIEU = ?   AND t1.AUDITORIA = ?  ";

		List<Vlistestprev> vlistestprevList = this.jdbcTemplate.query(query,
				this.rwMap, vlistestprev.getAnio(),
				vlistestprev.getTerritorio(), vlistestprev.getMes(),
				vlistestprev.getTipodocumento(), vlistestprev.getModalies(),
				vlistestprev.getModalieu(), vlistestprev.getAuditoria());
		return (Vlistestprev) DataAccessUtils.uniqueResult(vlistestprevList);
	}

	/**
	 * Removes a single row in the Vlistestprev table.
	 * 
	 * vlistestprev Vlistestprev
	 * 
	 * @param vlistestprev
	 *            the vlistestprev
	 */
	public void remove(Vlistestprev vlistestprev) {
		String query = "DELETE FROM VLISTESTPREV WHERE ANIO=? AND TERRITORIO=? AND MES=? AND TIPODOCUMENTO=? AND MODDALIES=? AND MODALIEU=? AND AUDITORIA=?";
		this.jdbcTemplate.update(query, vlistestprev.getAnio(),
				vlistestprev.getTerritorio(), vlistestprev.getMes(),
				vlistestprev.getTipodocumento(), vlistestprev.getModalies(),
				vlistestprev.getModalieu(), vlistestprev.getAuditoria());
	}

	/**
	 * Finds a list of rows in the Vlistestprev table.
	 * 
	 * vlistestprev Vlistestprev jqGridRequestDto JQGridRequestDto
	 * List<Vlistestprev>
	 * 
	 * @param vlistestprev
	 *            the vlistestprev
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<Vlistestprev> findAll(Vlistestprev vlistestprev,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.ANIO ANIO,t1.TERRITORIO TERRITORIO,t1.MES MES,t1.TIPODOCUMENTO TIPODOCUMENTO,t1.MODDALIES MODDALIES,t1.MODALIEU MODALIEU,t1.AUDITORIA AUDITORIA ");
		query.append("FROM VLISTESTPREV t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vlistestprev);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND MES IS NOT NULL  ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Vlistestprev>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Vlistestprev table using like.
	 * 
	 * vlistestprev Vlistestprev jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<Vlistestprev>
	 * 
	 * @param vlistestprev
	 *            the vlistestprev
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@SuppressWarnings("unchecked")
	@Transactional(readOnly = true)
	public List<Vlistestprev> findAllLike(Vlistestprev vlistestprev,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<Vlistestprev> result = null;

		StringBuilder query = new StringBuilder();
		List<Object> params = null;

		StringBuilder select = new StringBuilder(
				"SELECT COUNT(*) AS TOTAL, ANIO, TERRITORIO, TO_CHAR(FECPRE,'MM') AS MES, TIPODOCUMENTO ");
		StringBuilder from = new StringBuilder(" FROM VLISTESTPREV t1");
		StringBuilder where = new StringBuilder(
				" WHERE 1 = 1 AND MES IS NOT NULL ");
		StringBuilder groupby = new StringBuilder(
				" GROUP BY ANIO, TERRITORIO, TO_CHAR(FECPRE,'MM'), TIPODOCUMENTO ");

		if (vlistestprev.getAgrupacion() == null
				|| "".equals(vlistestprev.getAgrupacion())) {
			query.append(select);
			query.append(from);

			// WHERE
			Map<String, Object> mapaWhere = this.getWhereLikeMap(vlistestprev,
					startsWith);
			where.append(mapaWhere.get("query"));
			query.append(where);
			params = (List<Object>) mapaWhere.get("params");

			query.append(groupby);

			if (jqGridRequestDto != null) {
				query = JQGridManager.getPaginationQuery(jqGridRequestDto,
						query);
			}

			result = (List<Vlistestprev>) this.jdbcTemplate.query(
					query.toString(), this.rwMapListEstSinAgru,
					params.toArray());

		} else if (vlistestprev.getAgrupacion() != null
				&& "mop".equals(vlistestprev.getAgrupacion())) {
			query.append(select);
			query.append(", MODALIES, MODALIEU ");
			query.append(from);

			// WHERE
			Map<String, Object> mapaWhere = this.getWhereLikeMap(vlistestprev,
					startsWith);
			where.append(mapaWhere.get("query"));
			query.append(where);
			query.append(" AND MODALIES IS NOT NULL ");
			params = (List<Object>) mapaWhere.get("params");

			query.append(groupby);
			query.append(", MODALIES, MODALIEU  ");

			if (jqGridRequestDto != null) {
				query = JQGridManager.getPaginationQuery(jqGridRequestDto,
						query);
			}

			result = (List<Vlistestprev>) this.jdbcTemplate.query(
					query.toString(), this.rwMapListEstMOP, params.toArray());

		} else if (vlistestprev.getAgrupacion() != null
				&& "auditoria".equals(vlistestprev.getAgrupacion())) {
			query.append(select);
			query.append(", AUDITORIA ");
			query.append(from);

			// WHERE
			Map<String, Object> mapaWhere = this.getWhereLikeMap(vlistestprev,
					startsWith);
			where.append(mapaWhere.get("query"));
			query.append(where);
			query.append(" AND AUDITORIA IS NOT NULL ");
			params = (List<Object>) mapaWhere.get("params");

			query.append(groupby);
			query.append(", AUDITORIA ");

			if (jqGridRequestDto != null) {
				query = JQGridManager.getPaginationQuery(jqGridRequestDto,
						query);
			}

			result = (List<Vlistestprev>) this.jdbcTemplate.query(
					query.toString(), this.rwMapListEstAudi, params.toArray());
		}

		return result;
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Vlistestprev table.
	 * 
	 * vlistestprev Vlistestprev Long
	 * 
	 * @param vlistestprev
	 *            the vlistestprev
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Vlistestprev vlistestprev) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VLISTESTPREV t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vlistestprev);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND MES IS NOT NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Vlistestprev table using like.
	 * 
	 * vlistestprev Vlistestprev startsWith Boolean Long
	 * 
	 * @param vlistestprev
	 *            the vlistestprev
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@SuppressWarnings("unchecked")
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Vlistestprev vlistestprev, Boolean startsWith) {
		Long result = null;

		StringBuilder query = new StringBuilder();
		List<Object> params = null;

		StringBuilder select = new StringBuilder(
				"SELECT COUNT(1) FROM(SELECT '1' ");
		StringBuilder from = new StringBuilder(" FROM VLISTESTPREV t1");
		StringBuilder where = new StringBuilder(
				" WHERE 1 = 1 AND MES IS NOT NULL ");
		StringBuilder groupby = new StringBuilder(
				" GROUP BY ANIO, TERRITORIO, TO_CHAR(FECPRE,'MM'), TIPODOCUMENTO ");

		if (vlistestprev.getAgrupacion() == null
				|| "".equals(vlistestprev.getAgrupacion())) {
			query.append(select);
			query.append(from);

			// WHERE
			Map<String, Object> mapaWhere = this.getWhereLikeMap(vlistestprev,
					startsWith);
			where.append(mapaWhere.get("query"));
			query.append(where);
			params = (List<Object>) mapaWhere.get("params");

			query.append(groupby).append(")");

			result = this.jdbcTemplate.queryForLong(query.toString(),
					params.toArray());

		} else if (vlistestprev.getAgrupacion() != null
				&& "mop".equals(vlistestprev.getAgrupacion())) {
			query.append(select);
			query.append(from);

			// WHERE
			Map<String, Object> mapaWhere = this.getWhereLikeMap(vlistestprev,
					startsWith);
			where.append(mapaWhere.get("query"));
			query.append(where);
			query.append(" AND MODALIES IS NOT NULL ");
			params = (List<Object>) mapaWhere.get("params");

			query.append(groupby);
			query.append(", MODALIES, MODALIEU )");

			result = this.jdbcTemplate.queryForLong(query.toString(),
					params.toArray());

		} else if (vlistestprev.getAgrupacion() != null
				&& "auditoria".equals(vlistestprev.getAgrupacion())) {
			query.append(select);
			query.append(from);

			// WHERE
			Map<String, Object> mapaWhere = this.getWhereLikeMap(vlistestprev,
					startsWith);
			where.append(mapaWhere.get("query"));
			query.append(where);
			query.append(" AND AUDITORIA IS NOT NULL ");
			params = (List<Object>) mapaWhere.get("params");

			query.append(groupby);
			query.append(", AUDITORIA )");

			result = this.jdbcTemplate.queryForLong(query.toString(),
					params.toArray());
		}

		return result;
	}

	/**
	 * Reorder the data list of Vlistestprev selected for rup_table.
	 * 
	 * vlistestprev Vlistestprev jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean List<TableRowDto<Vlistestprev>>
	 * 
	 * @param vlistestprev
	 *            the vlistestprev
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<Vlistestprev>> reorderSelection(
			Vlistestprev vlistestprev, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ANIO ANIO,t1.TERRITORIO TERRITORIO,t1.MES MES,t1.TIPODOCUMENTO TIPODOCUMENTO,t1.MODDALIES MODDALIES,t1.MODALIEU MODALIEU,t1.AUDITORIA AUDITORIA ");
		// FROM
		query.append("FROM VLISTESTPREV t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vlistestprev,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND MES IS NOT NULL ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager
				.getReorderQuery(query, jqGridRequestDto, Vlistestprev.class,
						filterParamList,
						"ANIO,TERRITORIO,MES,TIPODOCUMENTO,MODDALIES,MODALIEU,AUDITORIA");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Vlistestprev>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 * filterParams Vlistestprev searchParams Vlistestprev jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto<Vlistestprev>>
	 * 
	 * @param filterParams
	 *            the filter params
	 * @param searchParams
	 *            the search params
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<Vlistestprev>> search(Vlistestprev filterParams,
			Vlistestprev searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.ANIO ANIO,t1.TERRITORIO TERRITORIO,t1.MES MES,t1.TIPODOCUMENTO TIPODOCUMENTO,t1.MODDALIES MODDALIES,t1.MODALIEU MODALIEU,t1.AUDITORIA AUDITORIA ");
		// FROM
		query.append("FROM VLISTESTPREV t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager
				.getSearchQuery(query, jqGridRequestDto, Vlistestprev.class,
						filterParamList, searchSQL, searchParamList,
						from_alias,
						"ANIO,TERRITORIO,MES,TIPODOCUMENTO,MODDALIES,MODALIEU,AUDITORIA");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Vlistestprev>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 * filtervlistestprev Vlistestprev jqGridRequestDto JQGridRequestDto
	 * startsWith Boolean
	 * 
	 * @param filtervlistestprev
	 *            the filtervlistestprev
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 */
	@Override
	public void removeMultiple(Vlistestprev filtervlistestprev,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.ANIO ANIO,t1.TERRITORIO TERRITORIO,t1.MES MES,t1.TIPODOCUMENTO TIPODOCUMENTO,t1.MODDALIES MODDALIES,t1.MODALIEU MODALIEU,t1.AUDITORIA AUDITORIA ");
		// FROM
		query.append("FROM VLISTESTPREV t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(
				filtervlistestprev, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Vlistestprev.class,
						query, params,
						"ANIO,TERRITORIO,MES,TIPODOCUMENTO,MODDALIES,MODALIEU,AUDITORIA");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Vlistestprev entity.
	 * 
	 * vlistestprev Vlistestprev Bean with the criteria values to filter by. Map
	 * created with two keys key query stores the sql query syntax key params
	 * stores the parameter values to be used in the condition sentence.
	 * 
	 * @param vlistestprev
	 *            the vlistestprev
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Vlistestprev vlistestprev) {

		StringBuilder where = new StringBuilder(
				VlistestprevDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vlistestprev != null && vlistestprev.getAnio() != null) {
			where.append(" AND t1.ANIO = ?");
			params.add(vlistestprev.getAnio());
		}
		if (vlistestprev != null && vlistestprev.getTerritorio() != null) {
			where.append(" AND t1.TERRITORIO = ?");
			params.add(vlistestprev.getTerritorio());
		}
		if (vlistestprev != null && vlistestprev.getMes() != null) {
			where.append(" AND t1.MES = ?");
			params.add(vlistestprev.getMes());
		}
		if (vlistestprev != null && vlistestprev.getTipodocumento() != null) {
			where.append(" AND t1.TIPODOCUMENTO = ?");
			params.add(vlistestprev.getTipodocumento());
		}
		if (vlistestprev != null && vlistestprev.getModalies() != null) {
			where.append(" AND t1.MODDALIES = ?");
			params.add(vlistestprev.getModalies());
		}
		if (vlistestprev != null && vlistestprev.getModalieu() != null) {
			where.append(" AND t1.MODALIEU = ?");
			params.add(vlistestprev.getModalieu());
		}
		if (vlistestprev != null && vlistestprev.getAuditoria() != null) {
			where.append(" AND t1.AUDITORIA = ?");
			params.add(vlistestprev.getAuditoria());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Vlistestprev entity.
	 * 
	 * vlistestprev Vlistestprev Bean with the criteria values to filter by.
	 * startsWith Boolean Map created with two keys key query stores the sql
	 * query syntax key params stores the parameter values to be used in the
	 * condition sentence.
	 * 
	 * @param vlistestprev
	 *            the vlistestprev
	 * @param startsWith
	 *            the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Vlistestprev vlistestprev,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				VlistestprevDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vlistestprev != null && vlistestprev.getAnio() != null) {
			where.append(" AND UPPER(t1.ANIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vlistestprev.getAnio().toUpperCase() + "%");
			} else {
				params.add("%" + vlistestprev.getAnio().toUpperCase() + "%");
			}
			where.append(" AND t1.ANIO IS NOT NULL");
		}
		if (vlistestprev != null && vlistestprev.getTerritorio() != null) {
			where.append(" AND UPPER(t1.TERRITORIO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vlistestprev.getTerritorio().toUpperCase() + "%");
			} else {
				params.add("%" + vlistestprev.getTerritorio().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TERRITORIO IS NOT NULL");
		}
		if (vlistestprev != null && vlistestprev.getMes() != null) {
			where.append(" AND UPPER(t1.MES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vlistestprev.getMes().toUpperCase() + "%");
			} else {
				params.add("%" + vlistestprev.getMes().toUpperCase() + "%");
			}
			where.append(" AND t1.MES IS NOT NULL");
		}
		if (vlistestprev != null && vlistestprev.getTipodocumento() != null) {
			where.append(" AND UPPER(t1.TIPODOCUMENTO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vlistestprev.getTipodocumento().toUpperCase() + "%");
			} else {
				params.add("%" + vlistestprev.getTipodocumento().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.TIPODOCUMENTO IS NOT NULL");
		}
		if (vlistestprev != null && vlistestprev.getModalies() != null) {
			where.append(" AND UPPER(t1.MODDALIES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vlistestprev.getModalies().toUpperCase() + "%");
			} else {
				params.add("%" + vlistestprev.getModalies().toUpperCase() + "%");
			}
			where.append(" AND t1.MODDALIES IS NOT NULL");
		}
		if (vlistestprev != null && vlistestprev.getModalieu() != null) {
			where.append(" AND UPPER(t1.MODALIEU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vlistestprev.getModalieu().toUpperCase() + "%");
			} else {
				params.add("%" + vlistestprev.getModalieu().toUpperCase() + "%");
			}
			where.append(" AND t1.MODALIEU IS NOT NULL");
		}
		if (vlistestprev != null && vlistestprev.getAuditoria() != null) {
			where.append(" AND UPPER(t1.AUDITORIA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vlistestprev.getAuditoria().toUpperCase() + "%");
			} else {
				params.add("%" + vlistestprev.getAuditoria().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.AUDITORIA IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
